$NOLIST

    NAME OsS3interfaceAsm

; this is os.S3interface.asm
; This will make ingrid look like a series
; III by providing a interface to udi calls.
; The calls are made through an interrupt 0c1h.
; These are just routed to the proper Dq call

    PUBLIC UdiInterface
    
;   EXTRN CheckCodeEscape:FAR
    EXTRN ConHexOut: FAR
    EXTRN CpWhoAmI: NEAR

RAM_CGROUP GROUP RAM_CODE


RAM_CODE SEGMENT PUBLIC 'CODE'
    ASSUME CS:RAM_CODE
        

PcbInfo STRUC
  pcbWhoCares DB 78 DUP (?)
  pWindowInfo DD ?
PcbInfo ENDS

windowInfo STRUC
  windowWhoCares DB 135 DUP (?)
  gotCodeEscape  DB ?
windowInfo ENDS
    
UdiInterface:

  CMP AX, 1eh   ; bounds check the call
  JA  badRoutine
  ADD AX, 113   ; get real code number
  JMP SHORT popTheStack

badRoutine:
  MOV AX, 94    ; guaranteed to be bad call (OsGetCardStatus)

popTheStack:
  POP BX        ; pop return ip
  POP BX        ; pop return cs
  POPF          ; pop flags
        
  PUSH AX       ; save routine num

; Check for a code escape
  CALL CpWhoAmI
  MOV  ES, AX
  LES  DI, ES:pWindowInfo
  CMP  ES:[DI].gotCodeEscape, 0
  JE   NoCodeEscape

  INT 112
  DB  112       ; checkCodeEscape routine

NoCodeEscape:
  POP  AX
        
  XOR  CX, CX      ; int vects
  MOV  ES, CX      ; in seg 0

  MOV  BX, 4 * 112 ; @ int 112

  LES  BX, DWORD PTR ES:[BX]

  INC  BX          ; get addr of
  INC  BX          ; indirect

  PUSH ES          ; push CS
  PUSH BX          ; push IP

LongRet PROC FAR
  RET              ; go to routine
LongRet ENDP

RAM_CODE ENDS

   END
